package gov.va.med.mhv.usermgmt.web.controller;

import javax.annotation.ManagedBean;
import javax.faces.event.ComponentSystemEvent;
import javax.servlet.http.HttpSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;

@ManagedBean
@Component
@Scope("session")
public class ConnectYourDocsController  extends AbstractController{
	
	private static final long serialVersionUID = 6889094990111312538L;
	private static Logger log = LogManager.getLogger(ConnectYourDocsController.class);
	
	
	public void init(ComponentSystemEvent event){
		
	}
	
	public boolean isPremiumAccountType(){
		boolean premiumUser=false;
		HttpSession session=PortalSessionThreadLocal.getHttpSession();
		String accountType=(String)session.getAttribute("LIFERAY_SHARED_accountType");
		if(accountType.equalsIgnoreCase("premium")){
			premiumUser=true;
		}
		return premiumUser;
	}

	public boolean isDsLogonUser() {
		boolean dslonUser=false;
		HttpSession session=PortalSessionThreadLocal.getHttpSession();
		String dslogonuserRole =(String)session.getAttribute("DSLOGON_USER_ROLE");
		if(dslogonuserRole != null){
			dslonUser=true;
		}
		return dslonUser;
	}
	
}
